module net.BurtonRadons.dig.platform.colorSelector;

private import net.BurtonRadons.dig.platform.base;
private import net.BurtonRadons.dig.platform.control;

/** Produces a dialog that allows the user to select a color.
  */

class ColorSelector
{
public:
    Color color; /**< The default color shown in the selector; this is also modified whenever a successful run is performed. */
    Color [16] customColors; /**< Custom colors array used by the selector. */

    /** Empty constructor. */
    this ()
    {
    }

    /** Uses this color as the default in the selector. */
    this (Color color)
    {
        this.color = color;
    }

    /** Shows the dialog and returns whether it was okay or canceled. */

    bit run ()
    {
        Color faker;

        return run (faker);
    }

    /** Show the dialog and return whether it was okay or canceled;
      * assigns color if it was okay.
      */

    bit run (out Color color)
    {
        _COLORREF [16] customs;
        TCHOOSECOLOR info;
        bit result = true;

        for (int c; c < 16; c ++)
            customs [c] = Control.digPlatformColorToCOLORREF (customColors [c]);

        info.lStructSize = info.size;
        info.hwndOwner = (_HANDLE) 0; /* Should set to any random Frame */
        info.hInstance = (_HANDLE) 0; /* For templates */
        info.rgbResult = Control.digPlatformColorToCOLORREF (this.color);
        info.lpCustColors = customs;

        info.Flags = 0;
        //info.Flags |= CC_ANYCOLOR; // Display all available colors in the set of basic colors.
        //info.Flags |= CC_ENABLEHOOK; // Enable the lpfnHook member.
        // CC_ENABLETEMPLATE; // hInstance and lpTemplateName combine to indicate a dialog box template.
        // CC_ENABLETEMPLATEHANDLE; // hInstance identifies a preloaded dialog box template.
        info.Flags |= CC_FULLOPEN; // Open up the custom colors controls.
        // CC_PREVENTFULLOPEN; // Disallow opening the custom colors controls.
        info.Flags |= CC_RGBINIT; // Use the rgbResult member for the default color.
        // CC_SHOWHELP; // Display the Help button.
        // CC_SOLIDCOLOR; // Only show solid colors in the set of basic colors.

        info.lCustData = 0; // Custom data passed to the function hook.
        info.lpfnHook = null; // Hook procedure.
        info.lpTemplateName = null; // zstring that names the dialog box template.

        if (!ChooseColorA (&info))
        {
            digPlatformCommDlgExtendedError ();
            result = false;
        }

        for (int c; c < 16; c ++)
            customColors [c] = Control.digPlatformColorFromCOLORREF (customs [c]);

        if (!result)
            return false;

        color = Control.digPlatformColorFromCOLORREF (info.rgbResult);
        this.color = color;
        return true;
    }
}